class Battle { // représente un jeu de bataille

	Deck player1;
	Deck player2;
	Deck trick;
	boolean turn;

	// constructeur d'une bataille sans cartes
	Battle() {
		player1 = new Deck();
		player2 = new Deck();
		trick = new Deck();
		turn = true;
	}
	
	// constructeur à partir des champs
	Battle(Deck player1, Deck player2, Deck trick) {
		this.player1 = player1;
		this.player2 = player2;
		this.trick = trick;
		turn = true;
	}

	// copie la bataille
	Battle copy() {
		Battle r = new Battle();
		r.player1 = this.player1.copy();
		r.player2 = this.player2.copy();
		r.trick = this.trick.copy();
		r.turn = this.turn;
		return r;
	}

	// chaîne de caractères représentant la bataille
	@Override
	public String toString() {
		return "Joueur 1 : " + player1.toString() + "\n" + "Joueur 2 : " + player2.toString() + "\nPli " + trick.toString();
	}

	// Question 3.1

	// constructeur d'une bataille avec un jeu de cartes de nbVals valeurs
	Battle(int nbVals) {
		// throw new Error("Constructeur Battle() à compléter (Question 3.1)");
		/*
		player1 = new Deck();
		player2 = new Deck();
		trick = new Deck();
		*/
		this();
		Deck d = new Deck(nbVals);
		d.riffleShuffle(7);
		for (int i = 0; i < 2*nbVals; i++) {
			player1.pick(d);
			player2.pick(d);
		}
		turn = true; //(Math.random() < .5);
	}

	// Question 3.2

	// teste si la partie est finie
	boolean isOver() {
		// throw new Error("Méthode isOver() à compléter (Question 3.2)");
		return player1.cards.isEmpty() || player2.cards.isEmpty();
	}

	// effectue un tour de jeu
	boolean oneRound() {
		// throw new Error("Méthode oneRound() à compléter (Question 3.2)");
		if (isOver()) return false;
		int card1, card2;
		if (turn) {
			card1 = trick.pick(player1);
			card2 = trick.pick(player2);
		} else {
			card2 = trick.pick(player2);
			card1 = trick.pick(player1);			
		}
		//Décommenter la ligne qui suit pour répondre à la Question 4.2
		//turn = !turn;
		while (card1 == card2)
			for (int i = 0; i < 2; i++)
				if (isOver()) return false;
				else {
					if (turn) {
						card1 = trick.pick(player1);
						card2 = trick.pick(player2);
					} else {
						card2 = trick.pick(player2);
						card1 = trick.pick(player1);			
					}
					//Décommenter la ligne qui suit pour répondre à la Question 4.2
					//turn = !turn;
				}
		if (card1 > card2)
			player1.pickAll(trick);
		else
			player2.pickAll(trick);
		return true;
	}

	// Question 3.3

	// renvoie le gagnant
	int winner() {
		// throw new Error("Méthode winner() à compléter (Question 3.3)");
		int c1 = player1.cards.size();
		int c2 = player2.cards.size();
		if (c1 == c2) return 0;
		if (c1 > c2) return 1;
		else return 2;
	}

	// effectue une partie avec un nombre maximum de coups fixé
	int game(int turns) {
		// throw new Error("Méthode game(int turns) à compléter (Question 3.3)");
		while (turns > 0 && oneRound())
			turns--;
		return winner();
	}

	// Question 4.1

	// effectue une partie sans limite de coups, mais avec détection des parties infinies
	int game() {
		// throw new Error("Méthode game() à compléter (Question 4.1)");
		// on utilise l'algorithme du lièvre et de la tortue pour repérer les parties infinies
		Battle turtle = this.copy();
		Battle hare = this;
		do {
			// Le lièvre joue deux tours ...
			if(!hare.oneRound()) return hare.winner();
			if(!hare.oneRound()) return hare.winner();
			// ... alors que la tortue joue un tour.
			turtle.oneRound();
		} while(!hare.toString().equals(turtle.toString()));
		return 3;
	}

	// Question 4.2

	// effectue des statistiques sur le nombre de parties infinies
	static void stats(int nbVals, int nbGames) {
		// throw new Error("Méthode stats(int bvVals, int nb_of_games) à compléter (Question 4.2)");
		int[] results = new int[4];
		for (int i = 0; i < nbGames; i++)
			results[new Battle(nbVals).game()]++;
		System.out.println("Statistiques sur les " + nbGames + " parties jouées :");
		System.out.println("   " + results[0] + " parties se sont terminées sur une égalité,");
		System.out.println("   " + results[1] + " parties ont été gagnées par le joueur 1,");
		System.out.println("   " + results[2] + " parties ont été gagnées par le joueur 2,");
		System.out.println("   " + results[3] + " parties sont infinies.");
	}
}